
import db from './database/db.js';

async function verifySync() {
    try {
        console.log("Verifying Database Sync & History...");
        const [rows] = await db.query("SELECT * FROM users WHERE role = 'admin' LIMIT 1");
        if (rows.length === 0) {
            console.log("No admin user found.");
            return;
        }
        const user = rows[0];
        let stats = typeof user.usage_stats === 'string' ? JSON.parse(user.usage_stats) : user.usage_stats;

        // Local Date
        const d = new Date();
        const localYMD = d.getFullYear() + '-' +
            String(d.getMonth() + 1).padStart(2, '0') + '-' +
            String(d.getDate()).padStart(2, '0');

        console.log("-----------------------------------------");
        console.log(`Local System Date:   ${localYMD}`);
        console.log(`Database Daily Date: ${stats.daily?.date}`);
        console.log("-----------------------------------------");
        console.log("Daily Stats (Today):");
        console.log("  API Calls:   ", stats.daily.apiCalls || 0);
        console.log("  Trends:      ", stats.daily.trendSearches || 0);
        console.log("-----------------------------------------");
        console.log("History Last Day (Yesterday's Archive):");
        console.log("  Date:        ", stats.history?.lastDay?.date);
        console.log("  API Calls:   ", stats.history?.lastDay?.apiCalls || 0);
        console.log("  Trends:      ", stats.history?.lastDay?.trendSearches || 0);

        if (stats.daily && stats.daily.date === localYMD) {
            console.log("\n✅ SYSTEM SYNCED. Current Day is reset to 0.");
            console.log("Any activity from before the fix/restart is now in 'History Last Day'.");
            console.log("Please generate a NEW trend to see it count towards Today.");
        }

    } catch (e) {
        console.error("Error:", e);
    } finally {
        process.exit();
    }
}

verifySync();
