const mysql = require('mysql2/promise');

async function checkUserModelUsage() {
    const connection = await mysql.createConnection({
        host: 'localhost',
        user: 'root',
        password: '',
        database: 'stockforge'
    });

    try {
        console.log('=== Checking User Model Usage Stats ===\n');

        // Get the most recent user (assuming you're the only one or most recent)
        const [users] = await connection.query(`
            SELECT uid, email, usage_stats 
            FROM users 
            ORDER BY last_login_at DESC 
            LIMIT 1
        `);

        if (users.length === 0) {
            console.log('No users found!');
            return;
        }

        const user = users[0];
        console.log('User:', user.email);
        console.log('UID:', user.uid);

        const stats = typeof user.usage_stats === 'string'
            ? JSON.parse(user.usage_stats)
            : user.usage_stats;

        console.log('\n=== Model Usage (from user.usage_stats.modelUsage) ===');
        if (stats.modelUsage) {
            Object.entries(stats.modelUsage).forEach(([modelId, usage]) => {
                console.log(`  ${modelId}: ${usage} calls`);
            });
        } else {
            console.log('  (No modelUsage data)');
        }

        console.log('\n=== Model Limits (from user.usage_stats.modelLimits) ===');
        if (stats.modelLimits) {
            Object.entries(stats.modelLimits).forEach(([modelId, limit]) => {
                const used = stats.modelUsage?.[modelId] || 0;
                const remaining = limit - used;
                console.log(`  ${modelId}:`);
                console.log(`    Limit: ${limit}`);
                console.log(`    Used: ${used}`);
                console.log(`    Remaining: ${remaining}`);
            });
        }

        console.log('\n=== Database api_key_usage (TODAY) ===');
        const today = new Date().toISOString().split('T')[0];
        const [dbUsage] = await connection.query(`
            SELECT model_id, SUM(api_calls) as total
            FROM api_key_usage
            WHERE user_uid = ? AND usage_date = ?
            GROUP BY model_id
        `, [user.uid, today]);

        dbUsage.forEach(row => {
            console.log(`  ${row.model_id}: ${row.total} calls`);
        });

    } catch (error) {
        console.error('Error:', error);
    } finally {
        await connection.end();
    }
}

checkUserModelUsage();
