export const getPacificDateKey = (offset = 0) => {
    const d = new Date();
    // Adjust to Pacific Time
    const ptDate = new Date(d.toLocaleString("en-US", { timeZone: "America/Los_Angeles" }));
    ptDate.setDate(ptDate.getDate() + offset);

    // Format YYYY-MM-DD manually to ensure local time representation of the PT date is used
    const year = ptDate.getFullYear();
    const month = String(ptDate.getMonth() + 1).padStart(2, '0');
    const day = String(ptDate.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
};
