
const mysql = require('mysql2/promise');
const crypto = require('crypto');
const dotenv = require('dotenv');
const fs = require('fs');
const path = require('path');

dotenv.config();

// Helper Copied from Server.js (FIXED VERSION)
const getLocalYMD = () => {
    const now = new Date();
    // Assuming PC is in a timezone similar to the user's expected 'Local' 
    // Actually we just want YYYY-MM-DD in local time of the NODE process.
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
};

async function testDeduct() {
    try {
        console.log("Starting DB Connection...");
        const db = await mysql.createPool({
            host: process.env.DB_HOST || 'localhost',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || '',
            database: process.env.DB_NAME || 'stockforge',
            waitForConnections: true,
            connectionLimit: 10,
            queueLimit: 0
        });

        // 1. Get Admin User
        const [rows] = await db.query("SELECT * FROM users WHERE role = 'admin' LIMIT 1");
        if (rows.length === 0) { console.error("No admin"); process.exit(1); }
        const user = rows[0];
        const uid = user.uid;

        console.log(`Testing with User: ${uid}`);

        let stats = typeof user.usage_stats === 'string' ? JSON.parse(user.usage_stats) : user.usage_stats;
        if (!stats) stats = {};
        if (!stats.daily) stats.daily = {};

        console.log("INITIAL STATS (Daily):", JSON.stringify(stats.daily));

        // 2. Simulate Deduct Logic (FIXED Logic from Server)
        const val = 1;
        const today = getLocalYMD();
        const todayReset = getLocalYMD(); // FIXED LINE

        console.log(`Local Date (todayReset): ${todayReset}`);
        console.log(`Stats Date: ${stats.daily.date}`);
        console.log(`Mismatch? ${stats.daily.date !== todayReset}`);

        if (stats.daily.date !== todayReset) {
            console.log(">>> RESETTING DAILY STATS <<<");
            stats.daily = { date: todayReset };
        }

        // Month logic omitted for brevity (assumed correct)

        stats.apiCalls = (stats.apiCalls || 0) + val;

        if (!stats.daily.apiCalls) stats.daily.apiCalls = 0;
        stats.daily.apiCalls += val;

        console.log("UPDATED STATS (Daily):", JSON.stringify(stats.daily));

        // 3. Write to DB
        console.log("Persisting to DB...");
        await db.query('UPDATE users SET usage_stats = ? WHERE uid = ?', [JSON.stringify(stats), uid]);

        console.log("✅ Simulate Success. Checking DB...");

        // 4. Verify Read
        const [vRows] = await db.query("SELECT usage_stats FROM users WHERE uid = ?", [uid]);
        const vStats = typeof vRows[0].usage_stats === 'string' ? JSON.parse(vRows[0].usage_stats) : vRows[0].usage_stats;

        console.log("FINAL DB STATE (Daily):", JSON.stringify(vStats.daily));

        if (vStats.daily.apiCalls > 0) {
            console.log("RESULT: SUCCESS - Persistence Works!");
        } else {
            console.log("RESULT: FAIL - Reads 0 after write.");
        }

    } catch (e) {
        console.error("Test Error:", e);
    } finally {
        process.exit();
    }
}

testDeduct();
