const jwt = require('jsonwebtoken');
const dotenv = require('dotenv');

dotenv.config();

const API_URL = 'http://localhost:3001/api/user/stats/dashboard';
const SECRET = process.env.JWT_SECRET || 'fallback_secret_dev_only_change_in_prod';
const UID = "34ad9630-ddfb-4773-a6d0-438b72c85c9e";

async function testDashboard() {
    try {
        const token = jwt.sign({ uid: UID, role: 'admin' }, SECRET, { expiresIn: '1h' });

        const res = await fetch(`${API_URL}?uid=${UID}`, {
            method: 'GET',
            headers: {
                'Authorization': `Bearer ${token}`
            }
        });

        if (res.ok) {
            const data = await res.json();
            console.log("Dashboard Stats Response:");
            console.log("Total entries:", Object.keys(data).length);
            console.log("\nSample entries:");
            Object.keys(data).slice(0, 5).forEach(key => {
                console.log(`${key}:`, JSON.stringify(data[key]));
            });

            // Check for today's date
            const today = new Date();
            const todayKey = today.getFullYear() + '-' +
                String(today.getMonth() + 1).padStart(2, '0') + '-' +
                String(today.getDate()).padStart(2, '0');
            console.log(`\nToday (${todayKey}):`, JSON.stringify(data[todayKey] || "NO DATA"));
        } else {
            console.error("Failed:", res.status, await res.text());
        }

    } catch (e) {
        console.error("Error:", e.message);
    }
}

testDashboard();
