@echo off
title StockForge AI - Server Launcher
color 0A

REM Ensure we are in the script directory
cd /d "%~dp0"

echo.
echo ========================================
echo   StockForge AI - Server Launcher
echo ========================================
echo.

REM Kill any processes on port 3001 (Backend)
echo [1/4] Cleaning up old backend processes...
for /f "tokens=5" %%a in ('netstat -ano ^| findstr ":3001" ^| findstr "LISTENING"') do (
    taskkill /F /PID %%a >nul 2>&1
)

REM Kill any processes on port 5173 (Frontend)  
echo [2/4] Cleaning up old frontend processes...
for /f "tokens=5" %%a in ('netstat -ano ^| findstr ":5173" ^| findstr "LISTENING"') do (
    taskkill /F /PID %%a >nul 2>&1
)

echo [3/4] Waiting 3 seconds for ports to release...
timeout /t 3 /nobreak >nul

echo [4/4] Starting servers...
echo.

REM Start Backend in new window
echo Starting Backend Server on port 3001...
echo Press Ctrl+C in the new window to stop the backend server
echo.
start "StockForge Backend" cmd /k "node server.js"

REM Wait a bit for backend to initialize
timeout /t 4 /nobreak >nul

REM Start Frontend in new window
echo Starting Frontend Dev Server on port 5173...
start "StockForge Frontend" cmd /k "npm run dev"

echo.
echo ========================================
echo   Servers Started!
echo ========================================
echo.
echo   Backend:  http://localhost:3001
echo   Frontend: http://localhost:5173
echo.
echo Check the opened terminal windows for logs.
echo If the frontend window closes immediately, there is an error.
echo.
pause
