
export const geoService = {
    getIpAndCountry: async (): Promise<{ ip: string, country: string }> => {
        try {
            // 1. Get IPv4 specifically
            const ipResponse = await fetch('https://api.ipify.org?format=json');
            if (!ipResponse.ok) throw new Error('Failed to fetch IPv4');
            const ipData = await ipResponse.json();
            const ipv4 = ipData.ip;

            // 2. Get Location Data for this IP
            const geoResponse = await fetch(`https://ipapi.co/${ipv4}/json/`);
            if (!geoResponse.ok) throw new Error('Failed to fetch geo data');
            const geoData = await geoResponse.json();

            return {
                ip: ipv4 || 'Unknown',
                country: geoData.country_name || 'Unknown'
            };
        } catch (error) {
            console.error('GeoService Error:', error);
            // Fallback to direct call if specific flow fails
            try {
                const response = await fetch('https://ipapi.co/json/');
                const data = await response.json();
                return {
                    ip: data.ip || 'Unknown',
                    country: data.country_name || 'Unknown'
                };
            } catch (e) {
                return { ip: 'Unknown', country: 'Unknown' };
            }
        }
    }
};
