import db from '../database/db.js';

const run = async () => {
    try {
        console.log('Updating IP address for local accounts...');

        // Update all users with country 'Slovenia' (which we set previously) or 'Localhost' to have a visible IP
        // This fixes the "Unknown" display for existing sessions/accounts
        await db.query('UPDATE users SET ip_address = "127.0.0.1" WHERE country = "Slovenia" OR country = "Localhost" OR ip_address IS NULL');

        console.log('✅ Updated users to have IP 127.0.0.1');

        process.exit(0);
    } catch (error) {
        console.error('Update failed:', error);
        process.exit(1);
    }
};

run();
