import db from '../database/db.js';

const run = async () => {
    try {
        console.log('Updating country for local accounts...');
        // Update specific users
        const emails = ['tillfix@gmail.com'];
        for (const email of emails) {
            await db.query('UPDATE users SET country = "Slovenia" WHERE email = ?', [email]);
            console.log(`Updated ${email} to Slovenia`);
        }

        // Also update the google user if we can match broad pattern or just all loopback IPs
        // The user showed a specific email google_1766...
        // Let's just update all users with 'Localhost' country to 'Slovenia'
        await db.query('UPDATE users SET country = "Slovenia" WHERE country = "Localhost"');
        console.log('Updated all Localhost users to Slovenia');

        process.exit(0);
    } catch (error) {
        console.error('Update failed:', error);
        process.exit(1);
    }
};

run();
