
import mysql from 'mysql2/promise';
import dotenv from 'dotenv';
import path from 'path';
import { fileURLToPath } from 'url';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

// Load env from parent dir
dotenv.config({ path: path.join(__dirname, '../.env') });

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge_db'
};

async function updateKey() {
    console.log('🔌 Connecting to database...');
    const conn = await mysql.createConnection(dbConfig);

    try {
        console.log('🔍 Searching for key ending in "-HgQ"...');

        const [rows] = await conn.query(`SELECT id, key_value, tier FROM api_keys WHERE key_value LIKE '%-HgQ'`);

        if (rows.length === 0) {
            console.log('❌ Key not found!');
            return;
        }

        const key = rows[0];
        console.log(`✅ Found Key ID: ${key.id} (Current Tier: ${key.tier})`);

        await conn.query(`UPDATE api_keys SET tier = 'PAID' WHERE id = ?`, [key.id]);

        console.log('🚀 Tier updated to PAID successfully.');

    } catch (error) {
        console.error('❌ Update failed:', error);
    } finally {
        await conn.end();
    }
}

updateKey();
