// Native fetch in Node 20+

const API_URL = 'http://localhost:3001/api';

async function test() {
    // 1. Register
    const email = `test_user_${Date.now()}@example.com`;
    const password = 'password123';

    console.log('Registering user:', email);
    const regRes = await fetch(`${API_URL}/auth/register`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ email, password, displayName: 'Tester' })
    });

    const regData = await regRes.json();
    if (!regData.success) {
        console.error('Registration failed:', regData);
        return;
    }

    const token = regData.token;
    console.log('Got token:', token ? 'YES' : 'NO');

    // 2. Fetch Stock Sites
    console.log('Fetching stock sites...');
    const sitesRes = await fetch(`${API_URL}/stock-sites`, {
        headers: {
            'Authorization': `Bearer ${token}`,
            'Content-Type': 'application/json'
        }
    });

    if (!sitesRes.ok) {
        console.error('Fetch sites failed:', sitesRes.status, sitesRes.statusText);
        return;
    }

    const sitesData = await sitesRes.json();
    console.log('Sites found:', sitesData.data ? sitesData.data.length : 'undefined');
    if (sitesData.data && sitesData.data.length > 0) {
        console.log('Sample site:', sitesData.data[0].name, 'Visible:', sitesData.data[0].is_visible);
    }
}

test();
