const fetch = require('node-fetch');

(async () => {
    try {
        // Test if backend returns tier field
        const response = await fetch('http://localhost:3001/api/user/keys?uid=test', {
            headers: {
                'Authorization': 'Bearer test-token'
            }
        });

        const data = await response.json();
        console.log('Backend response:', JSON.stringify(data, null, 2));

        if (data.keys && data.keys.length > 0) {
            console.log('\n✅ Sample key data:');
            console.log('  - id:', data.keys[0].id);
            console.log('  - tier:', data.keys[0].tier || '❌ TIER FIELD MISSING!');
            console.log('  - status:', data.keys[0].status);
        }
    } catch (error) {
        console.error('❌ Error:', error.message);
    }
})();
