
import mysql from 'mysql2/promise';
import dotenv from 'dotenv';
import path from 'path';
import { fileURLToPath } from 'url';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

// Load env from parent dir
dotenv.config({ path: path.join(__dirname, '../.env') });

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge_db'
};

async function setup() {
    console.log('🔌 Connecting to database...');
    const conn = await mysql.createConnection(dbConfig);

    try {
        console.log('🛠️ Creating api_key_usage table...');

        // Table for tracking usage per key per day
        await conn.query(`
            CREATE TABLE IF NOT EXISTS api_key_usage (
                key_hash VARCHAR(64) NOT NULL,
                usage_date DATE NOT NULL,
                api_calls INT DEFAULT 0,
                created_at BIGINT,
                PRIMARY KEY (key_hash, usage_date)
            )
        `);

        console.log('✅ Table api_key_usage is ready.');

    } catch (error) {
        console.error('❌ Setup failed:', error);
    } finally {
        await conn.end();
    }
}

setup();
