const mysql = require('mysql2/promise');

(async () => {
    try {
        const db = await mysql.createConnection({
            host: 'localhost',
            user: 'root',
            password: '',
            database: 'stockforge'
        });

        console.log('✅ Connected to database\n');

        // Get all API keys
        const [rows] = await db.query('SELECT id, key_value, tier, status FROM api_keys');

        console.log('📋 Current API Keys:');
        rows.forEach(row => {
            const maskedKey = '...' + row.key_value.slice(-4);
            console.log(`  ${maskedKey}: tier=${row.tier || 'NULL'}, status=${row.status}`);
        });

        // Set all keys to FREE tier by default (Google AI Studio free tier)
        console.log('\n🔧 Setting all keys to FREE tier...');
        const [result] = await db.query('UPDATE api_keys SET tier = "FREE" WHERE tier = "unknown" OR tier IS NULL');
        console.log(`✅ Updated ${result.affectedRows} keys to FREE tier`);

        // Show updated keys
        const [updated] = await db.query('SELECT id, key_value, tier FROM api_keys');
        console.log('\n📋 Updated API Keys:');
        updated.forEach(row => {
            const maskedKey = '...' + row.key_value.slice(-4);
            console.log(`  ${maskedKey}: tier=${row.tier}`);
        });

        console.log('\n✅ Done! Refresh your browser to see the FREE badges.');

        await db.end();
    } catch (error) {
        console.error('❌ Error:', error.message);
        process.exit(1);
    }
})();
