
import db from '../database/db.js';

async function setProperModelLimits() {
    try {
        console.log("🛠️ Setting Proper Model Limits in System Settings...");

        const [rows] = await db.query('SELECT * FROM system_settings WHERE id = 1');
        let settings = rows[0]?.settings ? (typeof rows[0].settings === 'string' ? JSON.parse(rows[0].settings) : rows[0].settings) : {};

        const currentLimits = settings.modelLimits || {};

        const defaults = {
            // Thinking
            'flash_lite': 1000,
            'flash_lite_2_0': 1000,
            'flash': 500,
            'flash_2_0': 500,
            'pro': 50,
            'pro_2_5': 50,
            'gemini_2_5_deep_think': 30,

            // Creative
            'imagen_4_fast': 100,
            'imagen_4_std': 30,
            'imagen_4_ultra': 10,
            'gemini_2_0_flash_image': 100,
            'gemini_2_5_flash_image': 100,
            'gemini_3_pro_image': 30,

            // Video
            'veo_3_1_fast': 10,
            'veo_3_1': 5,
            'veo_3_0': 10,
            'veo_2_0': 10
        };

        const updatedLimits = { ...currentLimits, ...defaults };

        settings.modelLimits = updatedLimits;

        // Also ensure credits per key is set
        if (!settings.creditsPerApiKey) settings.creditsPerApiKey = 2640;

        await db.query('UPDATE system_settings SET settings = ? WHERE id = 1', [JSON.stringify(settings)]);

        console.log("✅ System Settings Updated with Proper Limits:");
        console.table(updatedLimits);

    } catch (error) {
        console.error("Error:", error);
    } finally {
        process.exit();
    }
}

setProperModelLimits();
