
import db from '../database/db.js';
import { randomUUID } from 'crypto';

const tips = [
    {
        title: "Mastering Keywords",
        content: "Use specific, descriptive keywords. Instead of just 'dog', try 'golden retriever running in park'. Long-tail keywords help buyers find exactly what they need.",
        category: "Metadata",
        author: "StockForge Team"
    },
    {
        title: "Lighting Matters",
        content: "Natural light is often best for lifestyle stock photos. Shoot during the 'golden hour' (sunrise/sunset) for warm, soft lighting that buyers love.",
        category: "Photography",
        author: "StockForge Team"
    },
    {
        title: "Model Releases",
        content: "Always get a model release for any recognizable person in your photos. Without it, you can only sell as Editorial, which limits your earnings significantly.",
        category: "Legal",
        author: "StockForge Team"
    },
    {
        title: "Copy Space",
        content: "Leave empty space in your compositions (copy space) where designers can add text. This makes your images much more versatile for commercial use.",
        category: "Composition",
        author: "StockForge Team"
    },
    {
        title: "Authenticity Trends",
        content: "Buyers are looking for 'authentic' and 'candid' moments. Avoid overly staged poses. Capture real emotions and messy, real-life situations.",
        category: "Trends",
        author: "StockForge Team"
    },
    {
        title: "Technical Quality",
        content: "Upload at full resolution. Avoid excessive noise reduction or over-sharpening. Check for chromatic aberration and sensor dust spots before uploading.",
        category: "Technical",
        author: "StockForge Team"
    },
    {
        title: "Diverse Representation",
        content: "Include people of all ages, ethnicities, and abilities in your portfolio. Diversity and inclusion are major search trends in the current market.",
        category: "Trends",
        author: "StockForge Team"
    }
];

async function seedTips() {
    console.log("🌱 Seeding Tips...");
    try {
        // Optional: clear existing tips to avoid duplicates if running multiple times?
        // Let's just check count first.
        const [rows] = await db.query("SELECT COUNT(*) as count FROM tips");
        if (rows[0].count > 0) {
            console.log(`ℹ️ Tips table already has ${rows[0].count} entries. Skipping seed.`);
            process.exit(0);
        }

        for (const tip of tips) {
            const id = 'tip_' + randomUUID();
            await db.query(
                `INSERT INTO tips (id, title, text, category, created_at, is_deleted) VALUES (?, ?, ?, ?, ?, 0)`,
                [id, tip.title, tip.content, tip.category, Date.now()]
            );
            console.log(`✅ Added tip: ${tip.title}`);
        }

        console.log("🎉 Seeding complete!");
        process.exit(0);
    } catch (error) {
        console.error("❌ Error seeding tips:", error);
        process.exit(1);
    }
}

seedTips();
