import pool from '../database/db.js';

async function cleanSettings() {
    try {
        console.log("🔍 Fetching system settings...");
        const [rows] = await pool.query('SELECT * FROM system_settings LIMIT 1');

        if (rows.length === 0) {
            console.log("❌ No settings found!");
            process.exit(1);
        }

        let settingsBlob = rows[0].settings;
        const settings = typeof settingsBlob === 'string' ? JSON.parse(settingsBlob) : settingsBlob;

        if (!settings.modelLimits) {
            console.log("❌ No modelLimits found in settings.");
            process.exit(1);
        }

        console.log("BEFORE Cleanup:", JSON.stringify(settings.modelLimits, null, 2));

        // REMOVE LEGACY KEYS
        let changed = false;
        if ('veo' in settings.modelLimits) {
            console.log("🗑️ Removing legacy key: 'veo'");
            delete settings.modelLimits['veo'];
            changed = true;
        }
        if ('veo_hq' in settings.modelLimits) {
            console.log("🗑️ Removing legacy key: 'veo_hq'");
            delete settings.modelLimits['veo_hq'];
            changed = true;
        }

        if (changed) {
            console.log("AFTER Cleanup:", JSON.stringify(settings.modelLimits, null, 2));

            // Save back to DB
            const newSettingsJson = JSON.stringify(settings);
            await pool.query('UPDATE system_settings SET settings = ? WHERE id = ?', [newSettingsJson, rows[0].id]);
            console.log("✅ Settings updated successfully.");
        } else {
            console.log("✨ No legacy keys found. Nothing to do.");
        }

    } catch (err) {
        console.error("❌ Error:", err);
    } finally {
        process.exit();
    }
}

cleanSettings();
