const mysql = require('mysql2/promise');
require('dotenv').config();

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge'
};

async function createTable() {
    try {
        const connection = await mysql.createConnection(dbConfig);
        console.log('Connected to database.');

        const createQuery = `
            CREATE TABLE IF NOT EXISTS api_key_usage (
                id INT AUTO_INCREMENT PRIMARY KEY,
                key_hash VARCHAR(64) NOT NULL,
                date DATE NOT NULL,
                api_calls INT DEFAULT 0,
                model_id VARCHAR(100),
                UNIQUE KEY unique_usage (key_hash, date, model_id)
            );
        `;

        await connection.query(createQuery);
        console.log('Successfully created api_key_usage table.');
        await connection.end();
    } catch (error) {
        console.error('Failed to create table:', error);
    }
}

createTable();
