
import mysql from 'mysql2/promise';
import dotenv from 'dotenv';
import path from 'path';
import { fileURLToPath } from 'url';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

// Load env from parent directory
dotenv.config({ path: path.join(__dirname, '../.env') });

const pool = mysql.createPool({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'stockforge',
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0
});

async function run() {
    try {
        console.log("🔌 Connecting to database...");
        const connection = await pool.getConnection();
        console.log("✅ Connected.");

        console.log("🛠️ Fixing 'assets' table schema...");

        // Check if table exists
        const [tables] = await connection.query("SHOW TABLES LIKE 'assets'");
        if (tables.length === 0) {
            console.log("❌ Table 'assets' does not exist. Skipping.");
            process.exit(0);
        }

        // Run ALTER TABLE
        await connection.query("ALTER TABLE assets MODIFY url LONGTEXT NOT NULL");
        console.log("✅ Successfully changed 'url' column to LONGTEXT.");

        connection.release();
        process.exit(0);
    } catch (error) {
        console.error("❌ Error:", error.message);
        process.exit(1);
    }
}

run();
