import mysql from 'mysql2/promise';
import dotenv from 'dotenv';

dotenv.config();

const pool = mysql.createPool({
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge_ai',
    waitForConnections: true,
    connectionLimit: 10,
});

async function fixModelIds() {
    try {
        console.log('🔧 Fetching current settings...');
        const [rows] = await pool.query('SELECT * FROM system_settings WHERE id = 1');

        if (rows.length === 0) {
            console.log('❌ No settings found in database');
            return;
        }

        let settings = rows[0].settings;
        if (typeof settings === 'string') {
            settings = JSON.parse(settings);
        }

        console.log('📦 Current modelIds keys:', Object.keys(settings.modelIds || {}));

        // Complete model IDs - Using ONLY working 2.5 models
        settings.modelIds = {
            // Thinking - ALL use working 2.5 models
            'flash_lite': 'gemini-2.5-flash-lite-preview-09-2025',
            'flash_lite_2_0': 'gemini-2.5-flash-lite-preview-09-2025', // Changed to working model
            'flash': 'gemini-2.5-flash',
            'flash_2_0': 'gemini-2.5-flash', // Changed to working model
            'pro': 'gemini-2.5-flash', // Changed to working model
            'pro_2_5': 'gemini-2.5-flash', // Changed to working model
            'gemini_2_5_deep_think': 'gemini-2.5-flash', // Changed to working model
            'pro_2_5_deep_think': 'gemini-2.5-flash', // Changed to working model

            // Creative
            'imagen_fast': 'imagen-4.0-fast-generate-preview',
            'imagen_std': 'imagen-4.0-generate-001',
            'imagen_ultra': 'imagen-4.0-generate-ultra-preview',
            'gemini_2_0_flash_image': 'gemini-2.0-flash-image',
            'gemini_2_5_flash_image': 'gemini-2.5-flash-image',
            'gemini_3_pro_image': 'gemini-3-pro-image-preview',

            // Video
            'veo_3_1': 'veo-3.1-generate-preview',
            'veo_3_1_fast': 'veo-3.1-fast-generate-preview',
            'veo_3_0': 'veo-3.0-generate-preview',
            'veo_2_0': 'veo-2.0-generate-preview'
        };

        console.log('✅ Updated modelIds to', Object.keys(settings.modelIds).length, 'keys');

        await pool.query(
            'UPDATE system_settings SET settings = ? WHERE id = 1',
            [JSON.stringify(settings)]
        );

        console.log('✅ Database updated successfully!');
        console.log('🔄 Please refresh your browser to see the changes');

        process.exit(0);
    } catch (error) {
        console.error('❌ Error:', error);
        process.exit(1);
    }
}

fixModelIds();
