
import db from '../database/db.js';

async function debugUserStats() {
    try {
        console.log("🔍 Inspecting User Stats...");

        const [users] = await db.query('SELECT uid, email, usage_stats FROM users WHERE is_deleted = 0');

        for (const user of users) {
            console.log(`\nUser: ${user.email} (${user.uid})`);
            let stats = user.usage_stats;
            if (typeof stats === 'string') {
                try {
                    stats = JSON.parse(stats);
                } catch (e) {
                    console.log("  [Error parsing usage_stats JSON]");
                    continue;
                }
            }

            if (!stats) {
                console.log("  [No usage_stats found]");
                continue;
            }

            console.log("  Global Stats:", {
                apiCallsThisMonth: stats.apiCallsThisMonth,
                apiCallsLimit: stats.apiCallsLimit,
            });

            console.log("  Model Limits (Keys & Values):");
            if (stats.modelLimits) {
                Object.entries(stats.modelLimits).forEach(([k, v]) => {
                    console.log(`    "${k}": ${v}`);
                });
            } else {
                console.log("    [None]");
            }

            console.log("  Model Usage (Keys & Values):");
            if (stats.modelUsage) {
                Object.entries(stats.modelUsage).forEach(([k, v]) => {
                    console.log(`    "${k}": ${v}`);
                });
            } else {
                console.log("    [None]");
            }
        }

    } catch (error) {
        console.error("Error:", error);
    } finally {
        process.exit();
    }
}

debugUserStats();
