const mysql = require('mysql2/promise');
require('dotenv').config({ path: require('path').join(__dirname, '../.env') });

const pool = mysql.createPool({
    host: process.env.DB_HOST || '127.0.0.1',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge',
    port: process.env.DB_PORT || 3306
});

async function checkIds() {
    try {
        const [rows] = await pool.query('SELECT DISTINCT model_id FROM api_key_usage');
        console.log('--- DISTINCT MODEL IDs ---');
        rows.forEach(r => console.log(r.model_id));
        process.exit(0);
    } catch (e) {
        console.error(e);
        process.exit(1);
    }
}

checkIds();
