import mysql from 'mysql2/promise';
import dotenv from 'dotenv';
dotenv.config();

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge'
};

const debug = async () => {
    try {
        const conn = await mysql.createConnection(dbConfig);
        console.log('Connected to DB...');

        // 1. Check Table Structure
        console.log("Checking 'broadcasts' table columns:");
        const [columns] = await conn.query("SHOW COLUMNS FROM broadcasts");
        console.log(columns.map(c => c.Field).join(', '));

        // 2. List Existing Rows
        console.log("\nExisting Broadcasts:");
        const [rows] = await conn.query("SELECT * FROM broadcasts");
        console.log(rows);

        // 3. Try Inserting a dummy broadcast
        console.log("\nAttempting Insert...");
        const id = 'debug_' + Date.now();
        const testItem = {
            id,
            title: 'Debug Broadcast',
            message: 'This is a test.',
            type: 'notice',
            sent_at: Date.now(),
            read_count: 0,
            open_rate: 0,
            target_audience: 'All',
            is_deleted: 0
        };

        // Construct query manually to match server behaviour closely
        const keys = Object.keys(testItem);
        const values = Object.values(testItem);
        const placeholders = keys.map(() => '?').join(',');
        const colNames = keys.join(',');

        await conn.query(`INSERT INTO broadcasts (${colNames}) VALUES (${placeholders})`, values);
        console.log("Insert Successful!");

        await conn.end();
    } catch (error) {
        console.error("Debug failed:", error);
    }
};

debug();
