const mysql = require('mysql2/promise');
const dotenv = require('dotenv');
const path = require('path');

dotenv.config({ path: path.join(__dirname, '../.env') });

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge'
};

async function createTable() {
    let connection;
    try {
        connection = await mysql.createConnection(dbConfig);
        console.log('Connected to database.');

        const sql = `
            CREATE TABLE IF NOT EXISTS stock_sites (
                id VARCHAR(128) PRIMARY KEY,
                name VARCHAR(255),
                url VARCHAR(255),
                category VARCHAR(100),
                description TEXT,
                contributors VARCHAR(100),
                library_size VARCHAR(100),
                commission VARCHAR(100),
                is_visible BOOLEAN DEFAULT TRUE,
                pros JSON,
                cons JSON,
                is_deleted BOOLEAN DEFAULT FALSE
            );
        `;

        await connection.query(sql);
        console.log('stock_sites table created or already exists.');

    } catch (error) {
        console.error('Error creating table:', error);
    } finally {
        if (connection) await connection.end();
    }
}

createTable();
