const mysql = require('mysql2/promise');
require('dotenv').config();

async function createAuditTable() {
    let conn;
    try {
        console.log('Connecting to database...');
        conn = await mysql.createConnection({
            host: process.env.DB_HOST || '127.0.0.1',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || '',
            database: process.env.DB_NAME || 'stockforge'
        });

        console.log('Creating audit_logs table...');
        await conn.query(`
            CREATE TABLE IF NOT EXISTS audit_logs (
                id VARCHAR(128) PRIMARY KEY,
                action VARCHAR(255) NOT NULL,
                details TEXT,
                admin_uid VARCHAR(128),
                timestamp BIGINT,
                ip VARCHAR(64),
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )
        `);
        console.log('✅ audit_logs table created successfully.');

    } catch (error) {
        console.error('❌ Error creating table:', error);
    } finally {
        if (conn) await conn.end();
        process.exit();
    }
}

createAuditTable();
