
import db from '../database/db.js';

async function createActivitiesTable() {
    try {
        console.log("🔍 Checking for user_activities table...");

        const createTableSQL = `
        CREATE TABLE IF NOT EXISTS user_activities (
            id VARCHAR(128) PRIMARY KEY,
            user_uid VARCHAR(128) NOT NULL,
            type VARCHAR(50) NOT NULL, -- 'generate', 'login', 'setting', 'error'
            description TEXT,
            timestamp BIGINT,
            metadata JSON,
            FOREIGN KEY (user_uid) REFERENCES users(uid) ON DELETE CASCADE
        );
        `;

        await db.query(createTableSQL);
        console.log("✅ Table 'user_activities' created or already exists.");

        // Add index on user_uid and timestamp for fast dashboard lookups
        try {
            await db.query(`CREATE INDEX idx_user_activity ON user_activities(user_uid, timestamp DESC)`);
            console.log("✅ Index created.");
        } catch (e) {
            // Index might exist
            console.log("ℹ️ Index creation skipped (likely exists).");
        }

    } catch (error) {
        console.error("Error:", error);
    } finally {
        process.exit();
    }
}

createActivitiesTable();
