
import mysql from 'mysql2/promise';
import dotenv from 'dotenv';
dotenv.config();

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge_db'
};

async function cleanupKeys() {
    console.log('🔌 Connecting to database...');
    const conn = await mysql.createConnection(dbConfig);

    try {
        console.log('🔍 Searching for corrupted keys (containing "••••" or similar masks)...');

        // Find keys with dots (common mask character U+2022) or just multiple dots
        const [rows] = await conn.query(`SELECT id, user_uid, name, key_value FROM api_keys WHERE key_value LIKE '%•%' OR key_value LIKE '%...%'`);

        if (rows.length === 0) {
            console.log('✅ No corrupted keys found.');
            return;
        }

        console.log(`⚠️ Found ${rows.length} potentially corrupted keys:`);
        const idsToDelete = [];
        rows.forEach(row => {
            console.log(`   - ID: ${row.id}, User: ${row.user_uid}, Name: ${row.name}, Key (Start): ${row.key_value.substring(0, 10)}...`);
            idsToDelete.push(row.id);
        });

        if (idsToDelete.length > 0) {
            console.log(`🗑️ Deleting ${idsToDelete.length} corrupted keys...`);
            const placeholders = idsToDelete.map(() => '?').join(',');
            await conn.query(`DELETE FROM api_keys WHERE id IN (${placeholders})`, idsToDelete);
            console.log('✅ Corrupted keys deleted. Users will need to re-add them.');
        }

    } catch (error) {
        console.error('❌ Cleanup failed:', error);
    } finally {
        await conn.end();
    }
}

cleanupKeys();
