
import db from '../database/db.js';

async function checkUserStats() {
    try {
        // Get the specific user (assuming single user or grab first 'admin')
        const [users] = await db.query("SELECT uid, email, usage_stats FROM users WHERE role = 'admin' LIMIT 1");
        if (users.length === 0) {
            console.log("No admin user found.");
            process.exit();
        }

        const user = users[0];
        console.log("User:", user.email, user.uid);
        console.log("Usage Stats (Raw):", user.usage_stats);
        console.log("Usage Stats (Type):", typeof user.usage_stats);

        const [keys] = await db.query("SELECT * FROM api_keys WHERE user_uid = ?", [user.uid]);
        console.log("API Keys Count:", keys.length);
        console.log("API Keys:", keys);

        process.exit();
    } catch (error) {
        console.error("Error:", error);
        process.exit(1);
    }
}

checkUserStats();
