import mysql from 'mysql2/promise';
import dotenv from 'dotenv';
dotenv.config();

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge'
};

const check = async () => {
    try {
        const conn = await mysql.createConnection(dbConfig);
        const [rows] = await conn.query("SELECT COUNT(*) as count FROM tips WHERE is_deleted = 0");
        console.log("Active Tips Count:", rows[0].count);

        if (rows[0].count > 0) {
            const [tips] = await conn.query("SELECT * FROM tips WHERE is_deleted = 0 LIMIT 3");
            console.log("Sample:", tips);
        } else {
            console.log("No active tips found.");
        }
        await conn.end();
    } catch (error) {
        console.error("Check failed:", error);
    }
};

check();
