const mysql = require('mysql2/promise');
const path = require('path');
require('dotenv').config({ path: path.join(__dirname, '../.env') });

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge_db'
};

async function checkSites() {
    try {
        const conn = await mysql.createConnection(dbConfig);
        const [rows] = await conn.query('SELECT id, name, is_visible, is_deleted FROM stock_sites');
        console.log('Total Sites:', rows.length);
        console.table(rows);
        await conn.end();
    } catch (e) {
        console.error(e);
    }
}

checkSites();
