const mysql = require('mysql2/promise');
const dotenv = require('dotenv');
dotenv.config();

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge_v2'
};

async function check() {
    console.log('Connecting to DB...');
    const conn = await mysql.createConnection(dbConfig);

    try {
        const [users] = await conn.query('SELECT uid, email, usage_stats FROM users LIMIT 1');
        if (!users.length) return;
        const user = users[0];

        let stats = user.usage_stats;
        if (typeof stats === 'string') stats = JSON.parse(stats);

        console.log('--- USER STATS (JSON) ---');
        console.log('User:', user.email);
        console.log('Monthly Object:', JSON.stringify(stats.monthly, null, 2));
        console.log('Daily Object:', JSON.stringify(stats.daily, null, 2));

    } catch (e) {
        console.error(e);
    } finally {
        await conn.end();
    }
}

check();
