import mysql from 'mysql2/promise';

async function checkModelIds() {
    const connection = await mysql.createConnection({
        host: 'localhost',
        user: 'root',
        password: '',
        database: 'stockforge'
    });

    try {
        console.log('=== Checking api_key_usage table ===\n');

        // Get today's date in YYYY-MM-DD format
        const today = new Date().toISOString().split('T')[0];

        // Check what model_ids exist in the table for today
        const [rows] = await connection.query(`
            SELECT model_id, SUM(api_calls) as total_calls
            FROM api_key_usage
            WHERE usage_date = ?
            GROUP BY model_id
            ORDER BY total_calls DESC
        `, [today]);

        console.log('Model IDs in database for TODAY (' + today + '):');
        console.log('===================================');
        rows.forEach(row => {
            console.log(`${row.model_id}: ${row.total_calls} calls`);
        });

        console.log('\n=== What Models page expects ===\n');
        console.log('Flash Lite: gemini-2.5-flash-lite-preview-09-2025');
        console.log('Flash: gemini-2.5-flash');
        console.log('Pro: gemini-3-pro-preview');

    } catch (error) {
        console.error('Error:', error);
    } finally {
        await connection.end();
    }
}

checkModelIds();
