const mysql = require('mysql2/promise');
require('dotenv').config();

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge'
};

async function checkSchema() {
    try {
        const connection = await mysql.createConnection(dbConfig);
        const [rows] = await connection.query('DESCRIBE broadcasts');
        console.log('Schema for broadcasts:', rows);
        await connection.end();
    } catch (error) {
        console.error('Failed to describe table:', error);
    }
}

checkSchema();
