
import db from '../database/db.js';

async function checkKeys() {
    try {
        const [rows] = await db.query("SELECT * FROM api_keys");
        console.log("Found keys:", rows.length);
        rows.forEach(r => {
            console.log(`ID: ${r.id}, Name: ${r.name}, Key Value: ${r.key_value}`);
            if (r.key_value.includes('•')) {
                console.log("❌ CRITICAL: Key is masked in database!");
            } else {
                console.log("✅ Key appears unmasked (or is fully visible string).");
            }
        });
        process.exit();
    } catch (error) {
        console.error("Error:", error);
        process.exit(1);
    }
}

checkKeys();
