const mysql = require('mysql2/promise');

(async () => {
    try {
        const db = await mysql.createConnection({
            host: 'localhost',
            user: 'root',
            password: '',
            database: 'stockforge'
        });

        console.log('✅ Connected to database');

        // Check if tier column exists
        const [cols] = await db.query('SHOW COLUMNS FROM api_keys LIKE "tier"');

        if (cols.length === 0) {
            console.log('⚠️  TIER COLUMN MISSING - Adding it now...');
            await db.query('ALTER TABLE api_keys ADD COLUMN tier VARCHAR(20) DEFAULT "unknown" AFTER network');
            console.log('✅ Tier column added successfully');
        } else {
            console.log('✅ Tier column already exists');
        }

        // Check current tier values
        const [rows] = await db.query('SELECT id, key_value, tier FROM api_keys LIMIT 5');
        console.log('\n📋 Current API Keys:');
        rows.forEach(row => {
            const maskedKey = '...' + row.key_value.slice(-4);
            console.log(`  ${maskedKey} - Tier: ${row.tier || 'NULL'}`);
        });

        // Set all NULL/empty tiers to 'unknown'
        const [result] = await db.query('UPDATE api_keys SET tier = "unknown" WHERE tier IS NULL OR tier = ""');
        if (result.affectedRows > 0) {
            console.log(`\n✅ Updated ${result.affectedRows} keys to have tier = 'unknown'`);
        }

        console.log('\n🎯 Database is ready! Now restart your backend server.');

        await db.end();
    } catch (error) {
        console.error('❌ Error:', error.message);
        process.exit(1);
    }
})();
