import mysql from 'mysql2/promise';
import dotenv from 'dotenv';
dotenv.config();

const dbConfig = {
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge'
};

const migrate = async () => {
    try {
        const conn = await mysql.createConnection(dbConfig);
        console.log('Connected to DB...');

        try {
            await conn.query("ALTER TABLE support_messages ADD COLUMN sender VARCHAR(50) DEFAULT 'user'");
            console.log("Successfully added 'sender' column.");
        } catch (e) {
            if (e.code === 'ER_DUP_FIELDNAME') {
                console.log("'sender' column already exists.");
            } else {
                console.error("Error adding column:", e.message);
            }
        }

        await conn.end();
    } catch (error) {
        console.error("Migration failed:", error);
    }
};

migrate();
