
const mysql = require('mysql2/promise');
const dotenv = require('dotenv');
const path = require('path');

dotenv.config();

async function runMigration() {
    console.log("Checking api_keys table for 'is_deleted' column...");

    const connection = await mysql.createConnection({
        host: process.env.DB_HOST || 'localhost',
        user: process.env.DB_USER || 'root',
        password: process.env.DB_PASSWORD || '',
        database: process.env.DB_NAME || 'stockforge'
    });

    try {
        // Check if column exists
        const [columns] = await connection.query(`
            SELECT COLUMN_NAME 
            FROM INFORMATION_SCHEMA.COLUMNS 
            WHERE TABLE_SCHEMA = ? AND TABLE_NAME = 'api_keys' AND COLUMN_NAME = 'is_deleted'
        `, [process.env.DB_NAME || 'stockforge']);

        if (columns.length === 0) {
            console.log("Column 'is_deleted' not found. Adding it...");
            await connection.query(`
                ALTER TABLE api_keys 
                ADD COLUMN is_deleted BOOLEAN DEFAULT 0
            `);
            console.log("✅ 'is_deleted' column added successfully.");
        } else {
            console.log("ℹ️ 'is_deleted' column already exists.");
        }

    } catch (error) {
        console.error("❌ Migration failed:", error);
    } finally {
        await connection.end();
    }
}

runMigration();
