import db from '../database/db.js';

const run = async () => {
    try {
        console.log('Checking users table columns...');
        const [columns] = await db.query('SHOW COLUMNS FROM users');
        const columnNames = columns.map(c => c.Field);

        console.log('Existing columns:', columnNames);

        if (!columnNames.includes('ip_address')) {
            console.log('Adding ip_address column...');
            await db.query('ALTER TABLE users ADD COLUMN ip_address VARCHAR(45) DEFAULT NULL');
            console.log('✅ Added ip_address');
        } else {
            console.log('ℹ️ ip_address column already exists');
        }

        if (!columnNames.includes('country')) {
            console.log('Adding country column...');
            await db.query('ALTER TABLE users ADD COLUMN country VARCHAR(100) DEFAULT "Unknown"');
            console.log('✅ Added country');
        } else {
            console.log('ℹ️ country column already exists');
        }

        process.exit(0);
    } catch (error) {
        console.error('Migration failed:', error);
        process.exit(1);
    }
};

run();
