const mysql = require('mysql2/promise');
require('dotenv').config();

async function addAssetColumns() {
    const connection = await mysql.createConnection({
        host: process.env.DB_HOST,
        user: process.env.DB_USER,
        password: process.env.DB_PASSWORD,
        database: process.env.DB_NAME
    });

    try {
        console.log('[MIGRATION] Adding model_used and generation_settings columns to assets table...');

        // Add model_used column
        await connection.query(`
            ALTER TABLE assets 
            ADD COLUMN IF NOT EXISTS model_used VARCHAR(255) DEFAULT NULL
        `);

        // Add generation_settings column
        await connection.query(`
            ALTER TABLE assets 
            ADD COLUMN IF NOT EXISTS generation_settings TEXT DEFAULT NULL
        `);

        console.log('[MIGRATION] ✅ Columns added successfully!');
    } catch (error) {
        console.error('[MIGRATION] ❌ Error:', error.message);
    } finally {
        await connection.end();
    }
}

addAssetColumns();
