const mysql = require('mysql2/promise');
require('dotenv').config();

async function check() {
    const db = await mysql.createPool({
        host: process.env.DB_HOST || 'localhost',
        user: process.env.DB_USER || 'root',
        password: process.env.DB_PASSWORD || '',
        database: process.env.DB_NAME || 'stockforge'
    });

    const [rows] = await db.query("SELECT usage_stats FROM users WHERE uid = ?", ["34ad9630-ddfb-4773-a6d0-438b72c85c9e"]);
    const stats = typeof rows[0].usage_stats === 'string' ? JSON.parse(rows[0].usage_stats) : rows[0].usage_stats;
    console.log("Current trendSearches:", stats.daily.trendSearches);
    process.exit();
}

check();
