// Quick data inspector
// Run this in browser console to see actual chart data values

const inspectData = () => {
    // Get the Dashboard component's state (this is a hack for debugging)
    const dashboardElement = document.querySelector('[class*="animate-fade-in"]');

    console.log("=== CHART DATA INSPECTION ===");

    // Try to access React internals (only works in development)
    if (window.__REACT_DEVTOOLS_GLOBAL_HOOK__) {
        console.log("React DevTools available - use React DevTools to inspect component state");
    }

    // Alternative: Check if data exists in DOM
    const sparklines = document.querySelectorAll('.recharts-surface');
    console.log(`Found ${sparklines.length} Recharts surfaces in DOM`);

    if (sparklines.length === 0) {
        console.log("❌ No Recharts components rendered!");
        console.log("Possible causes:");
        console.log("1. ResponsiveContainer not sizing correctly");
        console.log("2. Data is falsy or empty");
        console.log("3. Recharts library issue");
    } else {
        console.log("✓ Recharts components ARE rendering");
        sparklines.forEach((chart, i) => {
            const bbox = chart.getBoundingClientRect();
            console.log(`Chart ${i}: ${bbox.width}x${bbox.height}`);
        });
    }
};

inspectData();
