const mysql = require('mysql2/promise');

async function fixUnknownModelIds() {
    const connection = await mysql.createConnection({
        host: 'localhost',
        user: 'root',
        password: '',
        database: 'stockforge'
    });

    try {
        console.log('=== Fixing \'unknown\' model IDs ===\n');

        // Check how many 'unknown' records exist
        const [rows] = await connection.query(`
            SELECT COUNT(*) as count FROM api_key_usage WHERE model_id = 'unknown'
        `);

        console.log(`Found ${rows[0].count} records with model_id='unknown'`);

        if (rows[0].count > 0) {
            console.log('\nUpdating records to use default thinking model (gemini-2.5-flash)...');

            // Update 'unknown' to 'gemini-2.5-flash' (default thinking model)
            const [result] = await connection.query(`
                UPDATE api_key_usage 
                SET model_id = 'gemini-2.5-flash'
                WHERE model_id = 'unknown'
            `);

            console.log(`✅ Updated ${result.affectedRows} records`);
            console.log('\nThese calls will now be attributed to Flash 2.5 model');
        } else {
            console.log('No records to fix!');
        }

    } catch (error) {
        console.error('Error:', error);
    } finally {
        await connection.end();
    }
}

fixUnknownModelIds();
