const mysql = require('mysql2/promise');
require('dotenv').config();

async function fixPacketSize() {
    try {
        const db = await mysql.createPool({
            host: process.env.DB_HOST || 'localhost',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || '',
            database: process.env.DB_NAME || 'stockforge'
        });

        console.log("Setting GLOBAL max_allowed_packet to 32MB...");
        await db.query("SET GLOBAL max_allowed_packet = 33554432"); // 32MB
        console.log("Success. NOTE: This might reset on server restart.");

        const [rows] = await db.query("SHOW VARIABLES LIKE 'max_allowed_packet'");
        console.log("New Max Allowed Packet:", rows);

    } catch (e) {
        console.error("Error setting packet size:", e);
    }
    process.exit();
}
fixPacketSize();
