const mysql = require('mysql2/promise');
require('dotenv').config();

async function fixSchema() {
    try {
        const db = await mysql.createPool({
            host: process.env.DB_HOST || 'localhost',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || '',
            database: process.env.DB_NAME || 'stockforge'
        });

        console.log("Altering assets table...");
        await db.query("ALTER TABLE assets MODIFY url LONGTEXT");
        console.log("Successfully changed 'url' column to LONGTEXT.");

    } catch (e) {
        console.error("Error:", e);
    }
    process.exit();
}
fixSchema();
