
const mysql = require('mysql2/promise');
const dotenv = require('dotenv');

dotenv.config();

const getLocalYMD = () => {
    const now = new Date();
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
};

async function verifyTrendIncrement() {
    try {
        console.log("Verifying Trend Logic...");
        const db = await mysql.createPool({
            host: process.env.DB_HOST || 'localhost',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || '',
            database: process.env.DB_NAME || 'stockforge',
            waitForConnections: true,
            connectionLimit: 10,
            queueLimit: 0
        });

        const [rows] = await db.query("SELECT * FROM users WHERE role = 'admin' LIMIT 1");
        const user = rows[0];
        const uid = user.uid;

        console.log(`User: ${uid}`);
        let stats = typeof user.usage_stats === 'string' ? JSON.parse(user.usage_stats) : user.usage_stats;

        console.log("BEFORE:", JSON.stringify(stats.daily));

        // SIMULATE LOGIC (Simulating server.js around line 980+)
        if (!stats) stats = {};

        // The Fix:
        if (!stats.daily) stats.daily = { date: getLocalYMD() };

        const today = getLocalYMD();
        console.log(`System Date: ${today}`);

        if (stats.daily.date !== today) {
            console.log("!!! TRIGGERING RESET !!!");
            if (!stats.history) stats.history = { lastDay: {} };
            stats.history.lastDay = { ...stats.daily };
            stats.daily = { date: today };
        } else {
            console.log("Date Match. No reset.");
        }

        // Increment Logic
        const statName = 'trendSearches';
        const val = 1;

        stats[statName] = (stats[statName] || 0) + val;

        if (!stats.daily[statName]) stats.daily[statName] = 0;
        stats.daily[statName] += val;

        console.log("AFTER (Memory):", JSON.stringify(stats.daily));

        // Persist
        await db.query('UPDATE users SET usage_stats = ? WHERE uid = ?', [JSON.stringify(stats), uid]);
        console.log("Saved to DB.");

        // Read Back
        const [vRows] = await db.query("SELECT usage_stats FROM users WHERE uid = ?", [uid]);
        const vStats = typeof vRows[0].usage_stats === 'string' ? JSON.parse(vRows[0].usage_stats) : vRows[0].usage_stats;

        console.log("FINAL DB STATE:", JSON.stringify(vStats.daily));

        if (vStats.daily.trendSearches > 0) {
            console.log("✅ SUCCESS! Trend Searched incremented.");
        } else {
            console.error("❌ FAILURE! Trend Searched is 0.");
        }

    } catch (e) {
        console.error("Error:", e);
    } finally {
        process.exit();
    }
}

verifyTrendIncrement();
