import pool from './database/db.js';

async function debugSettings() {
    const db = pool;
    try {
        const [rows] = await db.query('SELECT * FROM system_settings LIMIT 1');
        if (rows.length > 0) {
            let settingsBlob = rows[0].settings;
            const settings = typeof settingsBlob === 'string' ? JSON.parse(settingsBlob) : settingsBlob;
            console.log('System Settings (Full JSON):');
            console.log(JSON.stringify(settings, null, 2));
            if (settings && settings.modelLimits) {
                console.log('--- Model Limits ---');
                console.log(JSON.stringify(settings.modelLimits, null, 2));
            }
        } else {
            console.log('No system settings found.');
        }
    } catch (err) {
        console.error(err);
    } finally {
        process.exit();
    }
}

debugSettings();
