
const jwt = require('jsonwebtoken');
const dotenv = require('dotenv');

dotenv.config();

// Config
const API_URL = 'http://localhost:3001/api/user/stats/increment';
const SECRET = process.env.JWT_SECRET || 'fallback_secret_dev_only_change_in_prod';
const UID = "34ad9630-ddfb-4773-a6d0-438b72c85c9e";

async function testLiveIncrement() {
    try {
        console.log("Generating Token...");
        const token = jwt.sign({ uid: UID, role: 'admin' }, SECRET, { expiresIn: '1h' });

        console.log("Sending Request to:", API_URL);
        const res = await fetch(API_URL, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${token}`
            },
            body: JSON.stringify({
                uid: UID,
                statName: 'trendSearches',
                amount: 1,
                modelId: 'gemini-2.0-flash-thinking-exp'
            })
        });

        console.log("Status:", res.status);
        const text = await res.text();
        console.log("Response:", text);

        if (res.ok) {
            console.log("✅ LIVE API SUCCESS!");
        } else {
            console.error("❌ API FAILED");
        }

    } catch (e) {
        console.error("❌ CONNECTION ERROR:", e.cause || e.message);
    }
}

testLiveIncrement();
