-- Migration: Fix api_key_usage column name from 'date' to 'usage_date'
-- This ensures consistency with server.js queries
-- Created: 2025-12-18

-- Step 1: Rename date column to usage_date
ALTER TABLE api_key_usage CHANGE COLUMN `date` `usage_date` DATE NOT NULL;

-- Step 2: Drop old unique constraint if exists
ALTER TABLE api_key_usage DROP INDEX IF EXISTS unique_usage;

-- Step 3: Recreate unique constraint with correct column name
ALTER TABLE api_key_usage ADD UNIQUE KEY unique_usage (key_hash, usage_date, model_id);

-- Step 4: Verify the change
SELECT 
    COLUMN_NAME, 
    DATA_TYPE, 
    IS_NULLABLE,
    COLUMN_KEY
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'stockforge' 
  AND TABLE_NAME = 'api_key_usage'
ORDER BY ORDINAL_POSITION;
