-- Migration: Add tier column to api_keys table
-- Date: 2025-12-10
-- Description: Adds tier field to store FREE/PAID designation for API keys

USE stockforge;

-- Add tier column if it doesn't exist
ALTER TABLE api_keys 
ADD COLUMN IF NOT EXISTS tier VARCHAR(20) DEFAULT 'unknown' AFTER network;

-- Update existing keys to 'unknown' tier (they will be detected on next validation)
UPDATE api_keys SET tier = 'unknown' WHERE tier IS NULL;

SELECT 'Migration completed: Added tier column to api_keys table' AS status;
