import mysql from 'mysql2/promise';
import dotenv from 'dotenv';
dotenv.config();

// Create connection pool
const pool = mysql.createPool({
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'stockforge',
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0
});

// Helper to check connection
export const checkConnection = async () => {
    try {
        const connection = await pool.getConnection();
        console.log("✅ Custom MySQL Database Connected Successfully!");
        connection.release();
        return true;
    } catch (error) {
        console.error("❌ MySQL Connection Failed:", error.message);
        return false;
    }
};

// Export pool for queries
export default pool;
